//https://www.diva-portal.org/smash/get/diva2:1223894/FULLTEXT01.pdf

float height_alter(float altitude, float weather_map, float coverage){
    float stop_altitude = saturate(weather_map + 0.12);

    float attenuation = saturate(remap(altitude, 0.0, 0.07, 0.0, 1.0));
          attenuation *= saturate(remap(altitude, stop_altitude * 0.2, stop_altitude, 1.0, 0.0));
          //attenuation = pow(attenuation, saturate(remap(altitude, 0.6, 0.9, 1.0, 1.0 - 0.4 / coverage)));

    return attenuation;
}

float density_alter(float altitude, float weather_map){ 
    float attenuation = altitude * saturate(remap(altitude, 0.0, 0.2, 0.0, 1.0));
          attenuation *= weather_map * 2.0;
          attenuation *= saturate(remap(altitude, 0.9, 1.0, 1.0, 0.0));

    return attenuation * pi;
}

float volumetric_clouds_density(clouds_3D_settings vc, vec3 position){
      if(position.y <= vc.altitude_min || position.y >= vc.altitude_max) return 0.0;

      vc.thickness = mix(vc.thickness, 2400.0, wetness);

      float altitude = (position.y - vc.altitude_min) / vc.thickness;
      float animation = frameTimeCounter * vc.time_shift;

      vec3 direction0 = normalize(vec3(-1.0, 0.0, 1.0));
      vec3 direction1 = normalize(vec3(-1.0, 0.5, 1.0));
      
      vec3 position0 = (position + animation * direction0) / vc.scale_mask;
      vec3 position1 = (position + animation * direction1) / vc.scale_detail;

      float weather_map = voronoi_noise(position0.xz);
            weather_map = saturate(weather_map * 3.0 - 0.7);

      float attenuation0 = height_alter(altitude, weather_map, vc.coverage);
      float attenuation1 = density_alter(altitude, weather_map);
      
      float local_coverage = 1.0 - voronoi_noise(position0.xz / 3.0);
            local_coverage = saturate(local_coverage * 3.0 - 0.7);

      float global_coverage = mix(vc.coverage, vc.weather_coverage, wetness) + mix(local_coverage, 0.0, wetness);

      float noise0 = voronoi_noise(position0.xz) * mix(1.0, 2.5, wetness);
            noise0 = -(global_coverage - noise0);
            noise0 += attenuation0;

      float noise1 = perlin_fbm(position1, vc.octaves1);
            noise1 = mix(noise1, 1.0 - noise1, saturate(altitude / 5.0));
            noise1 *= 1.0 / exp(global_coverage * 0.75);
            
	if(noise0 <= 0.0) return 0.0;
	//if(noise1 <= 0.0) return 0.0;
	
      return saturate(attenuation1 * (noise0 - noise1) * 2.0) * vc.density;
}

#if defined DEFERRED1
      float volumetric_clouds_transmittance(clouds_3D_settings vc, vec3 position, vec3 direction, const int steps){
            float ray_length = 64.0;
            vec3 ray_increment = direction * ray_length;
            vec3 ray_position = position + ray_increment * 0.5;
            
            float transmittance = 0.0;

            for(int i = 0; i < steps; i++){
                  float density = ray_length * volumetric_clouds_density(vc, ray_position);
                  if(density <= 0.0) continue;
                  
                  ray_position += ray_increment * (i + 0.5);
                  transmittance += ray_position.y > vc.altitude_max ? 0.0 : density;
                  ray_length *= 1.5;
            }

            return transmittance;
      }

      vec4 volumetric_clouds(vec3 position, vec3 direction, vec3 sun_direction, vec3 moon_direction, vec3 noise, vec3 atmosphere){
            atmosphere_constant ac = atmosphere_s();
            clouds_3D_settings vc = s_clouds3D();

            vec3 clouds_scattering;
            float transmittance = 1.0;

            vec3 up_position = vec3(0.0, 1.0, 0.0);
            vec3 view_position = vec3(0.0, ac.planet_radius + cameraPosition.y, 0.0);
            
            float VdotL = dot(position, direction);
            float VdotU = dot(position, up_position);
            float LdotU = dot(direction, -up_position);

            vec2 sphere = ray_sphere_intersection(view_position, position, ac.planet_radius * 0.99995);
            vec2 sphere_min = ray_sphere_intersection(view_position, position, ac.planet_radius + vc.altitude_min);
            vec2 sphere_max = ray_sphere_intersection(view_position, position, ac.planet_radius + vc.altitude_max);

            if((eyeAltitude < vc.altitude_min && sphere.y > 0.0) || (eyeAltitude > vc.altitude_max && position.y > 0)) return vec4(0.0, 0.0, 0.0, 1.0);

            float dist0 = eyeAltitude > vc.altitude_max ? sphere_max.x : sphere_min.y;
            float dist1 = eyeAltitude > vc.altitude_max ? sphere_min.x : sphere_max.y;

            float range = (1.0 - saturate((eyeAltitude - vc.altitude_max) * 0.1)) * (1.0 - saturate((vc.altitude_min - eyeAltitude) * 0.1));

            vec3 position0 = position * dist0;
                 position0 = position0 * (1.0 - range);
                 position0 = clouds_curvature(position0);

            vec3 position1 = position * dist1;
                 position1 = mix(position1, position * vc.altitude_min * 12.0, range);
                 position1 = clouds_curvature(position1);

            vec3 clouds_increment = (position1 - position0) / vc.steps0;
            vec3 clouds_position = clouds_increment * noise.x + position0 + cameraPosition;

            float clouds_length = length(clouds_increment);

            for(int i = 0; i < vc.steps0; i++, clouds_position += clouds_increment){
                  if(transmittance <= vc.treshold) break;

                  float density = volumetric_clouds_density(vc, clouds_position) * clouds_length;
                  if(density <= 0.0) continue;

                  float step_transmittance = exp2(-density);
                  float step_transmittance_fraction = 1.0 - step_transmittance;

                  float direct_transmittance = volumetric_clouds_transmittance(vc, clouds_position, direction, 6);
                  float indirect_transmittance = volumetric_clouds_transmittance(vc, clouds_position, up_position, 4) * 0.1;
                  float bounce_transmittance = volumetric_clouds_transmittance(vc, clouds_position, -up_position, 2);

                  float powder = 1.0 - 0.97 * exp(-4.0 * density);
			float a = 1.0, b = 1.0, c = 1.0;
				  
                  for(int j = 0; j < vc.steps1; ++j){
                        float s_transmittance = (-transmittance * (step_transmittance * a) + transmittance) * (step_transmittance_fraction * a);

                        float direct_step_transmittance = s_transmittance * exp(-direct_transmittance * b);
                        float indirect_step_transmittance = s_transmittance * exp(-indirect_transmittance * b);
                        float bounce_step_transmittance = s_transmittance * exp(-bounce_transmittance * b);

                        float phase0 = volumetric_clouds_phase(VdotL, c);

                        clouds_scattering.x += direct_step_transmittance * powder * phase0;
                        clouds_scattering.y += indirect_step_transmittance * powder;
                        clouds_scattering.z += bounce_step_transmittance * powder;
						
			      a *= 0.6;
				b *= 0.4;
				c *= 0.8;
                  }

                  transmittance *= step_transmittance;
            }

            transmittance = saturate((transmittance - vc.treshold) / (1.0 - vc.treshold));

            vec3 sunlight = atmospheric_transmittance(sun_direction, moon_direction);

            vec3 skylight = texture2(colortex1, project_sphere(up_position)).xyz;
                 skylight = mix(skylight, (skylight + skylight.g * 1.4) * 0.5, wetness);

            vec3 transmittance0 = atmospheric_transmittance(ac, vec3(0.0, ac.planet_radius + cameraPosition.y, 0.0), position, direction);
            vec3 transmittance1 = atmospheric_transmittance(ac, vec3(0.0, ac.planet_radius + cameraPosition.y, 0.0) + position0, position, direction);
			
            vec3 scattering = clouds_scattering.x * sunlight;
                 scattering += clouds_scattering.y * skylight;
                 scattering += clouds_scattering.z * sunlight * abs(LdotU) * rpi * 0.05 * (1.0 - wetness);
		     scattering = mix(atmosphere * (1.0 - transmittance), scattering, saturate(transmittance0 / transmittance1));
                  
            #if ATMOSPHERE_TYPE == 0
                  return vec4(scattering, transmittance);
            #elif ATMOSPHERE_TYPE == 1
                  return vec4(0.0, 0.0, 0.0, 1.0);
            #endif
      }
#endif